#!/bin/sh

. /usr/share/passwall2/utils.sh
LOCK_FILE=${LOCK_PATH}/${CONFIG}_monitor.lock

ENABLED=$(config_t_get global enabled 0)
[ "$ENABLED" != 1 ] && return 1
ENABLED=$(config_t_get global_delay start_daemon 0)
[ "$ENABLED" != 1 ] && return 1
sleep 58s
while [ "$ENABLED" -eq 1 ]; do
	[ -f "$LOCK_FILE" ] && {
		sleep 6s
		continue
	}
	touch $LOCK_FILE
	[ -d ${TMP_SCRIPT_FUNC_PATH} ] && {
		for filename in $(ls ${TMP_SCRIPT_FUNC_PATH} | grep -v "^_"); do
			cmd=$(cat ${TMP_SCRIPT_FUNC_PATH}/${filename})
			cmd_check=$(echo $cmd | awk -F '>' '{print $1}')
			[ -n "$(echo $cmd_check | grep "dns2socks")" ] && cmd_check=$(echo $cmd_check | sed "s#:# #g")
			icount=$(pgrep -f "$(echo $cmd_check)" | wc -l)
			if [ $icount = 0 ]; then
				#echo "${cmd} crashed, restarting." >> /tmp/log/passwall2.log
				eval $(echo "nohup ${cmd} 2>&1 &") >/dev/null 2>&1 &
			fi
		done
	}
	
	rm -f $LOCK_FILE
	sleep 58s
done
